var samplePageObj = {
  // 샘플 타이틀
  title: '대용량 데이터 조회',
  subtitle: 'FastLoad의 성능을 확인합니다.',
  // 샘플 설명
  desc: 'IB Sheet 8에서 새롭게 추가된 랜더링 방식인 FastLoad(SearchMode:0)를 이용하여 대용량 데이터에 대한 조회/조작 성능을 확인하는 예제 입니다.<br/>데이터 생성 버튼을 누른 후, 데이터 로드를 하면 시트에 데이터가 조회됩니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 0
    },
    Def: {
      Col: {
        RelWidth: 1 // 컬럼에 들어가는 셀의 상대적인 크기 설정 (자유로운 기준치를 설정가능)
      }
    },
    LeftCols: [
      {
      // 컬럼 헤더 설정
        Header: 'No.', // 헤더 로우의 SEQ 컬럼에 해당하는 셀에 표시될 title 값
        Name: 'SEQ', // colName 컬럼명을 설정 (Data와 Matching)
        Type: 'Int', // 컬럼 타입 설정 : Html, Text, Int, Float, Button, Lines, Enum, Radio, Img, Link, Icon, Bool
        RelWidth: 0,
        Width: 80, // 컬럼의 너비 기본 너비 설정(px)
        Align: 'Center' // 컬럼의 내용 정렬 방식 설정 {"Left": 좌측 정렬,"Center": 가운데 정렬,"Right": 우측 정렬}
      }
    ],
    Cols: [
      {
        Header: '회사',
        Name: 'sCompany',
        Type: 'Text',
        MinWidth: 150, // 컬럼의 최소 너비 설정(px) RelWidth를 설정해도 MinWidth만큼의 크기까지만 가변가능합니다.
        Align: 'Center'
      },
      {
        Header: '판매 국가',
        Name: 'sCountry',
        MinWidth: 100,
        Type: 'Text',
        Align: 'Center'

      },
      {
        Header: '판매 수량',
        Name: 'sSaleQuantity',
        Type: 'Int',
        MinWidth: 100
      },
      {
        Header: '판매 증가량',
        Name: 'sSaleIncrease',
        Type: 'Int',
        MinWidth: 100,
      },
      {
        Header: '가격',
        Name: 'sPrice',
        Type: 'Int',
        MinWidth: 150,
        Format: '#,##0원' // 화면에 표시될 셀 값의 Format 형태를 설정
      },
      {
        Header: '만족도',
        Name: 'sSatisfaction',
        Type: 'Int',
        MinWidth: 100,
        Format: '#\\%'
      }
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><select class=\'mgr10\' id=\'massData\'><option value=\'100000\'>100,000 건</option><option value=\'200000\'>200,000 건</option><option value=\'300000\'>300,000 건</option><option value=\'400000\'>400,000 건</option><option value=\'500000\'>500,000 건</option></select>'
            + '<button class=\'mainbtn\' onclick=\'sampleBtn(this,parseInt(massData.value) || 10000)\'>데이터 로드</button></div>'
            + ' <div id=\'dataTime\'></div> <div id=\'estTime\'>데이터 로딩: 0 ms / 0 초</div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options // 생성될 시트의 속성
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    setTimeout(function () {
      sheet.showMessage('데이터 조회 중...', 4, 1);
    }, 1);
    setTimeout(function () {
      dataTime.textContent = '데이터 생성중입니다.';
      sheet.loadSearchData(samplePageObj.externalFunction.createData(document.getElementById('massData').value));
    }, 50);
  },

  // event구문
  event: {
    onDataLoad: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
      var leDate = new Date();

      estTime.textContent = '데이터 로딩: ' + (leDate - lsDate) + ' ms / ' + ((leDate - lsDate) / 1000) + ' 초';
      sheet.hideMessage();
    },
    onSearchFinish: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
      var leDate = new Date();

      estTime.textContent += ' (총 렌더링: ' + (leDate - lsDate) + ' ms / ' + ((leDate - lsDate) / 1000) + ' 초)';
    }
  },

  externalFunction: {
    // 임시 데이터 생성 함수
    createData: function (count) {
      var start = new Date();
      var data = [];
      var company = [
        'Google',
        'Apple',
        '삼성전자',
        'LG전자',
        '한화',
        'Microsoft',
        '현대',
        '현기차',
        'SK',
        '롯데'
      ];
      var country = [
        '미국',
        '일본',
        '한국',
        '영국',
        '캐나다',
        '중국',
        '프랑스',
        '브라질',
        '인도',
        '이탈리아'
      ];

      for (var i = 0; i < count; i++) {
        data.push({
          sCompany: company[Math.floor(Math.random() * 10)],
          sCountry: country[Math.floor(Math.random() * 10)],
          sSaleQuantity: Math.floor(Math.random() * 100000),
          sSaleIncrease: Math.floor(Math.random() * 10000),
          sPrice: Math.floor(Math.random() * 10000000),
          sSatisfaction: Math.floor(Math.random() * (100 - 50 + 1) + 50),
        });
      }
      var cols = sheet.getCols();

      for (var i = 0; i < cols.length; i++) {
        if (sheet.Cols[cols[i]].Visible == 0) {
          cols.splice(i, i + 1);
        }
      }

      dataTime.textContent = '데이터 생성 (' + (cols.length * data.length).toLocaleString() + ' 셀): ' + (new Date() - start) + ' ms / ' + ((new Date() - start) / 1000) + ' 초';

      // Not used by jsfiddle.
      // 데이터 구문 처리
      var showData = [];

      for (var i = 0; i < data.length && i < 20; i++) {
        showData.push(data[i]);
      }
      var _data = JSON.stringify(showData, null, 2);

      if (data.length > 20) { _data = _data.substring(0, _data.length - 1) + '...\n]'; }
      try {
        myTabs.contents.items(1).setContents('<pre><code class="language-json">' + _data + '</code></pre>');

        hljs.initHighlighting.called = false;
        hljs.initHighlighting();
      } catch (e) {
        console.log(e.message);
      }
      // Not used by jsfiddle.
      window.lsDate = new Date();

      return data;
    }
  },

  // data
  data: '해당 화면에서는 데이터가 동적으로 생성됩니다.'
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
